n <- 200

x1 <- rnorm(n) - 1
x2 <- rnorm(n) + 1
y1 <- x1^2 + x1 + rnorm(n)
y2 <- x2^2 + x2 + rnorm(n)

fit1 <- lm(y1 ~ x1)
fit2 <- lm(y2 ~ x2)

df <- data.frame(x = c(x1, x2), y = c(y1, y2), sample = c(rep("a", n), rep("b", n)))

gg_color_hue <- function(n) {
  hues = seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}
cols = gg_color_hue(4)

library(ggplot2)
scatter.plot <- ggplot(df) + aes(x = x, y = y, col = sample, shape = sample) + geom_point(alpha = 0.5, size = 2) + geom_abline(intercept = fit1$coef[1], slope = fit1$coef[2], col = cols[1]) + geom_abline(intercept = fit2$coef[1], slope = fit2$coef[2], col = cols[3], linetype = "dashed") + theme_bw(base_size = 15)

density.plot <- ggplot(df) + aes(x = x, col = sample, linetype = sample) + geom_density() + theme_bw(base_size = 15)

library(gridExtra)
pdf("conspiracy.pdf", width = 8, height = 8)
grid.arrange(scatter.plot + xlab(""), density.plot, nrow = 2, heights=unit(c(6,2), c("inch", "inch")), widths = unit(c(8), c("inch")))
dev.off()

## Matching
d <- outer(x1, x2, function(x, y) abs(x - y))
m <- matrix(0, n, 2)
for (i in 1:n) {
    dd <- apply(d, 1, min)
    m[i, 1] <- which.min(dd)
    m[i, 2] <- which.min(d[m[i, 1], ])
    d[m[i, 1], ] <- Inf
    d[, m[i, 2]] <- Inf
}
ind <- abs(x1[m[, 1]] - x2[m[, 2]]) < 0.1
x1 <- x1[m[ind, 1]]
x2 <- x2[m[ind, 2]]
y1 <- y1[m[ind, 1]]
y2 <- y2[m[ind, 2]]
n <- sum(ind)

fit1 <- lm(y1 ~ x1)
fit2 <- lm(y2 ~ x2)

df <- data.frame(x = c(x1, x2), y = c(y1, y2), sample = c(rep("a", n), rep("b", n)))

gg_color_hue <- function(n) {
  hues = seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}
cols = gg_color_hue(4)

library(ggplot2)
scatter.plot <- ggplot(df) + aes(x = x, y = y, col = sample, shape = sample) + geom_point(alpha = 0.5, size = 2) + geom_abline(intercept = fit1$coef[1], slope = fit1$coef[2], col = cols[1]) + geom_abline(intercept = fit2$coef[1], slope = fit2$coef[2], col = cols[3], linetype = "dashed") + theme_bw(base_size = 15) + scale_x_continuous(limits = c(-4, 4))

density.plot <- ggplot(df) + aes(x = x, col = sample, linetype = sample) + geom_density() + theme_bw(base_size = 15) + scale_x_continuous(limits = c(-4, 4))

library(gridExtra)
pdf("conspiracy_match.pdf", width = 8, height = 8)
grid.arrange(scatter.plot + xlab(""), density.plot, nrow = 2, heights=unit(c(6,2), c("inch", "inch")), widths = unit(c(8), c("inch")))
dev.off()
