library(lme4)
source('crt.R')


#Simulation 2


num_individuals <- 200
num_steps <- 8
num_iters <- 1000

effect_vector <- rep(0, num_steps)
effect_vector[1] = 0.1
effect_vector[2] = 0.3
effect_vector[3] = 0.6
effect_vector[4] = 0.4
effect_vector[5] = 0.2


#MCRTs+Z & MCRTs+F

list_crts = list()
list_crts_f = list()
tt = 1
for (index in 1:3){
  cat("\n")
  cat("index=",index)
  
  if (index ==1){
    weight_list <- c(0,0.1)
  }else{
    weight_list <- c(0.1)
  }

  for (weight in weight_list){
    
    cat("\n")
    cat("weight=",weight)
    cat("\n")

    mat1 <- matrix(0, num_iters,5)
    mat2 <- matrix(0, num_iters,5)
    mat3 <- matrix(0, num_iters,5)
    mat4 <- matrix(0, num_iters,5)
    check1 <- 0
    check2 <- 0
    check3 <- 0
    check4 <- 0
    check5 <- 0
    check6 <- 0


    for (seed in 1:num_iters){


      data_xyz <- synthetic(num_individuals,num_steps,effect_vector,seed,weight,index,normalize=TRUE,include_x=TRUE) 
      
      for (lag in 0:4){
        
        
        data_list <- data_swd(data_xyz,lag,sample_split=TRUE)
        
        p_list <- crt_swd(data_list, type='ci')
        ci <- global_ci(data_list,p_list,method='fisher')
        ci_ <- global_ci(data_list,p_list,method='zscore')
        
        i <- lag + 1

        mat1[seed,i] <- (effect_vector[i]>=ci[1])*(effect_vector[i]<=ci[2])*1.0
        mat2[seed,i] <- ci[2] - ci[1]
        
        mat3[seed,i] <- (effect_vector[i]>=ci_[1])*(effect_vector[i]<=ci_[2])*1.0
        mat4[seed,i] <- ci_[2] - ci_[1]
        
      }
      check2 <- check2 + 1
      check1 <- check1 + mat1[seed,]
      check3 <- check3 + mat2[seed,]
      
      cat("\n")
      cat("seed=",seed)
      cat("\n")
      cat("coverage=", check1/check2)
      cat("\n")
      cat("length=", check3/check2)
      cat("\n")  
      
      
      check5 <- check5 + 1
      check4 <- check4 + mat3[seed,]
      check6 <- check6 + mat4[seed,]
      
      cat("coverage=", check4/check5)
      cat("\n")
      cat("length=", check6/check5)
      cat("\n")  

    }

  
    cat("coverage_mcrts:",colMeans(mat1))
    cat("\n")
    cat("CI length_mcrts:",colMeans(mat2))
    cat("\n")
    
    cat("coverage_mcrts+:",colMeans(mat3))
    cat("\n")
    cat("CI length_mcrts+:",colMeans(mat4))
    cat("\n")
    
    list_crts[[tt]] <- c(index,weight,colMeans(mat1),colMeans(mat2))
    list_crts_f[[tt]] <- c(index,weight,colMeans(mat3),colMeans(mat4))
    tt <- tt+1
  }
}

save(list_crts, file="results/sim_2_mcrts_z.RData")
save(list_crts_f, file="results/sim_2_mcrts_f.RData")





#The mixed effect model


list_mixed = list()
tt <- 1
for (index in 1:3){
  
  
  cat("\n")
  cat("index=",index)
  
  if (index ==1){
    weight_list <- c(0,0.1)
  }else{
    weight_list <- c(0.1)
  }
  
  
  for (weight in weight_list){
    
    cat("\n")
    cat("weight=",weight)
    cat("\n")
    
    mat1 <- matrix(0, num_iters,5)
    mat2 <- matrix(0, num_iters,5)
    for (seed in 1:num_iters){
      data_xyz <- synthetic(num_individuals,num_steps,effect_vector,seed,weight,index,normalize=FALSE,include_x=TRUE)
      model = lmer(y ~  (1 | id) +  x + t + z_0 + z_1 + z_2+ z_3 + z_4+z_5+z_6+z_7,  data=data_xyz, REML=FALSE)
      result<- confint(model, method = "Wald",level = 0.9)
      lower<- result[6:10,1]
      upper<- result[6:10,2]
      
      for (i in 1:5){
        
        mat1[seed,i] <- (effect_vector[i]>=lower[i])*(effect_vector[i]<=upper[i])*1.0
        mat2[seed,i] <- upper[i]- lower[i]
      }
    }
    
    cat("coverage:",colMeans(mat1))
    cat("\n")
    cat("CI length:",colMeans(mat2))
    cat("\n")
    
    list_mixed[[tt]] <- c(index,weight,colMeans(mat1),colMeans(mat2))
    tt <- tt+1
  }
}

save(list_mixed, file="results/sim_2_mixed.RData")


